unit USalvarGrafico;

interface

uses
  UGrafico, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StrUtils, Dialogs, StdCtrls, ExtCtrls, Mask, Buttons,

  JPEG, Series, DBChart;

type
  TFrmSalvarGrafico = class(TForm)
    rgpPagina: TRadioGroup;
    rgpArquivo: TRadioGroup;
    EdtNomeArquivo: TEdit;
    Label1: TLabel;
    btnFechar: TBitBtn;
    btnSalvar: TBitBtn;
    SaveDialog1: TSaveDialog;
    btnNomeArq: TSpeedButton;
    procedure EdtNomeArquivoChange(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure rgpPaginaClick(Sender: TObject);
    procedure EdtNomeArquivoKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnNomeArqClick(Sender: TObject);
  private
    { Private declarations }
    pgs: Integer;
    DBChart: TDBChart;  //includa unit DBChart
    function CreateFileName(FileName: TFileName; Index: Integer): TFileName;
    procedure GerarFigura(FileName: TFileName);
    procedure GerarPDF(FileName: TFileName);
  public
    { Public declarations }
    class procedure Execute(AOwner: TComponent; MyDBChart: TDBChart);
  end;

var
  FrmSalvarGrafico: TFrmSalvarGrafico;


implementation

uses TeEngine, UImprimir;


{$R *.dfm}

{ TFrmSalvarGrafico }

procedure TFrmSalvarGrafico.GerarFigura(FileName: TFileName);
var
  ext: ShortString;
  bmp, bmpDestino: TBitmap;
  y: longint;
  jpeg: TJPEGImage;
  pgAtual, i: byte;
  dc: HDC;

begin
  pgAtual:= DBChart.Page;
  visible:= false;
  ext:= ExtractFileExt(EdtNomeArquivo.Text);
  //verifica se o arquivo a ser salvo  JPEG
  if AnsiSameText(ext, '.jpg') then
  begin
     jpeg:= TJPEGImage.Create;
     bmp:= TBitmap.Create;
     bmp.width := DBChart.Width;
     bmp.Height := DBChart.Height;
  end;

  try
    //se for pra salvar somente a pgina atual
    if rgpPagina.ItemIndex = 1 then
    begin
       {salva a pgina atual do grfico em formato bmp}
       DBChart.SaveToBitmapFile(FileName);
       if AnsiSameText(ext, '.jpg') then
       begin
         {se a extenso do arquivo for .jpg,
         carrega o arquivo .bmp salvo no objeto bmp}
         bmp.LoadFromFile(FileName);
         //converte o bmp para jpg
         jpeg.Assign(bmp);
         jpeg.JPEGNeeded;
         //salvo o arquivo jpg
         jpeg.SaveToFile(FileName);
       end;
    end
    //seno, se for pra salvar todas as pginas
    else
    begin
      //se for pra salvar cada pgina num arquivo
      if rgpArquivo.ItemIndex = 0 then
      begin
        try
          {lao de repetio para percorrer as pginas do grfico}
          for i:= 1 to pgs do
          begin
             DBChart.Page := i;
             if AnsiSameText(ext, '.jpg') then
             begin
               DBChart.Update;
               DC:= DBChart.DelphiCanvas.Handle;
               BitBlt(bmp.Canvas.Handle,0,0,bmp.width, bmp.height,DC,0,0,SRCCOPY);
               jpeg.Assign(bmp);
               jpeg.JPEGNeeded;
               {a funo CreateFileName gera uma numerao no
               nome de arquivo passado como parmetro, utilizando
               a varivel I (varivel de controle do For)}
               jpeg.SaveToFile(CreateFileName(FileName, i));
             end
             else DBChart.SaveToBitmapFile(CreateFileName(FileName, i));
          end;
        finally
          DBChart.Page:= pgAtual;
          if AnsiSameText(ext, '.jpg') then
             ReleaseDC(handle,dc);
        end;
      end
      //seno, se for pra salvar todas as pginas num nico arquivo
      else
      begin
        bmpDestino:= TBitmap.Create;
        try
          {a altura do bmp ser definida pela
          altura do grfico multiplicada
          pelo nmero de pginas para que
          caibam todas as pginas do
          grfico na mesma figura}
          bmpDestino.Height := DBChart.Height*pgs;
          bmpDestino.Width:= DBChart.Width;
          if bmp = nil then
             bmp:= TBitmap.Create;
          bmp.width := DBChart.Width;
          bmp.Height := DBChart.Height;
          for i:= 1 to pgs do
          begin
             {a varivel Y define o Top da pgina do grfico
             dentro da figura que est sendo criada}
             y:= DBChart.Height*(i-1);
             DBChart.Page := i;
             DBChart.Update;
             DC:= DBChart.DelphiCanvas.Handle;
             BitBlt(bmp.Canvas.Handle,0,0,bmp.width, bmp.height,DC,0,0,SRCCOPY);
             {o bmpDestino conter todas as pginas do grfico
             na mesma figura. O procedimento draw copia a pgina atual
             do grfico (armazenada em bmp) para dentro da figura final}
             bmpDestino.Canvas.draw(0,y,bmp);
          end;
          
          if AnsiSameText(ext, '.jpg') then
          begin
            jpeg.Assign(bmpDestino);
            jpeg.JPEGNeeded;
            jpeg.SaveToFile(FileName);
          end
          else bmpDestino.SaveToFile(FileName);
        finally
          DBChart.Page:= pgAtual;
          FreeAndNil(bmpDestino);
          ReleaseDC(handle,DC);
        end;
      end;
    end;
  finally
    if AnsiSameText(ext, '.jpg') then
    begin
      FreeAndNil(jpeg);
      FreeAndNil(bmp);
    end;
  end;
end;

function TFrmSalvarGrafico.CreateFileName(FileName: TFileName;
  Index: Integer): TFileName;
var Ext: ShortString;
begin
  //pega a extenso do arquivo
  Ext:= ExtractFileExt(FileName);
  {remove a extenso do arquivo para colocar um
  nmero sequencial no final do nome do mesmo}
  FileName := ChangeFileExt(FileName, '');
  {gera o nome do arquivo Contendo o
  nome original, mais um nmero sequencial
  indicando a pgina, mais a extenso.}
  result:= Format('%s PG %d%s', [FileName, Index, Ext]);
end;

procedure TFrmSalvarGrafico.EdtNomeArquivoChange(Sender: TObject);
var ext: ShortString;
begin
  {pega e extenso do arquivo}
  ext:= ExtractFileExt(EdtNomeArquivo.Text);
  rgpArquivo.Controls[1].Enabled :=
    (rgpPagina.ItemIndex = 0) and
    (pgs > 1) and
    (not AnsiSameText(ext,'.pdf'));
  if not rgpArquivo.Controls[1].Enabled then
     rgpArquivo.ItemIndex := 0;
  btnSalvar.enabled:=
    (trim(EdtNomeArquivo.Text) <> '');
end;

procedure TFrmSalvarGrafico.btnSalvarClick(Sender: TObject);
var ext: ShortString;
begin
  ext:= ExtractFileExt(EdtNomeArquivo.Text);
  try
     //muda o cursor para uma Ampulheta
     Screen.Cursor:= crHourGlass;
     {verifica se a extenso do arquivo  .pdf}
     if AnsiSameText(ext,'.pdf') then
        GerarPDF(EdtNomeArquivo.Text)
     else GerarFigura(EdtNomeArquivo.Text);
  finally
     //volta o cursor para o formato padro
     Screen.Cursor:= crDefault;
  end;
end;


procedure TFrmSalvarGrafico.rgpPaginaClick(Sender: TObject);
begin
  EdtNomeArquivoChange(EdtNomeArquivo);
end;


class procedure TFrmSalvarGrafico.Execute(AOwner: TComponent; MyDBChart: TDBChart);
begin
  FrmSalvarGrafico:= TFrmSalvarGrafico.create(AOwner);
  try
    with FrmSalvarGrafico do
    begin
      {atribui o grfico passado no parmetro
      MyDBChart ao objeto privado DBChart,
      tornando-o disponvel em qualquer parte
      do cdigo do form}
      DBChart:= MyDBChart;

      {includa unit Series}
      {Se a primeira srie do grfico
      no for em formato de pizza, ento
      a varivel pgs receber o total
      de pginas do grfico. Seno,
      esta receber 1 pois em grfico de pizza
      s dever haver uma pgina, porm
      o DBChart pode criar vrias pginas
      para o grfico de pizza, mas o contedo
      sempre ser o mesmo.  um pequeno problema
      que existe no DBChart.}
      if not(MyDBChart.Series[0] is TPieSeries) then
         pgs:= DBChart.NumPages
      else pgs:= 1;

      {Atribui um nome padro ao arquivo.
      A arquivo ser salvo na pasta do
      executvel, sendo que o nome do mesmo
      ser o ttulo do grfico.}
      SaveDialog1.FileName :=
         ExtractFilePath(Application.ExeName) +
         trim(DBChart.Title.Text.Text);
      EdtNomeArquivo.Text := SaveDialog1.FileName + '.pdf';

      rgpPagina.Controls[1].Enabled := pgs > 1;
      {habilita-se a segunda opo do rgpArquivo
      somente se a quantidade de pginas for
      maior que 1}
      rgpArquivo.Controls[1].Enabled := false;
      ShowModal;
    end;
  finally
    FrmSalvarGrafico.free;
    FrmSalvarGrafico:= nil;
  end;
end;

procedure TFrmSalvarGrafico.GerarPDF(FileName: TFileName);
var
  bmp: TBitmap;
  {declarada Unit JPEG}
  jpg: TJPEGImage;
  dc: HDC;
  
  i, fim, pgAtual, inicio: byte;

begin
  {pega a pgina atual antes do incio da exportao}
  pgAtual:= DBChart.Page;
  try
    {pega o intervalo de pginas a serem exportadas}
    if rgpPagina.ItemIndex = 0 then
    begin
      inicio:= 1;
      fim:= pgs;
    end
    else
    begin
      inicio:= pgAtual;
      fim:= pgAtual;
    end;

    visible:= false;
    bmp:= TBitmap.Create;
    jpg:= TJPEGImage.Create;

    bmp.width := DBChart.Width;
    bmp.Height := DBChart.Height;

    FrmImprimir:= TFrmImprimir.Create(Self);
    //define o nome do arquivo PDF a ser gerado
    FrmImprimir.PReport1.FileName := FileName;
    //inicia a gerao do PDF
    FrmImprimir.PReport1.BeginDoc;

    {lao de repetio para percorrer
    as pginas do grfico e inserir
    no arquivo PDF}
    for i:= inicio to fim do
    begin
       //muda a pgina atual do grfico
       DBChart.Page := i;
       DBChart.Update;
       {pega o DeviceContext (que armazena informaes
       sobre a figura)}
       DC:= DBChart.DelphiCanvas.Handle;
       //copia as informaes da figura para o bmp
       BitBlt(bmp.Canvas.Handle,0,0,bmp.width,bmp.height,DC,0,0,SRCCOPY);
       //converte o bmp para jpg
       jpg.Assign(bmp);
       {procedimento necessrio quando o jpg for gerado
       a partir de um bmp}
       jpg.JPEGNeeded;

       //atribuia o jpg no relatrio
       FrmImprimir.PRJpegImage1.Picture.Assign(jpg);
       //imprime o pgina contendo a figura no arquivo PDF
       FrmImprimir.PReport1.Print(FrmImprimir.PRPage1);
    end;
    //finaliza a gerao do PDF
    FrmImprimir.PReport1.EndDoc;
  finally
    {volta o grfico para a pgina que estava
    antes do incio da exportao}
    DBChart.Page:= pgAtual;
    //destroi objetos criados 
    FreeAndNil(bmp);
    FreeAndNil(jpg);
    FreeAndNil(FrmImprimir);
    ReleaseDC(handle,DC);
  end;
end;

procedure TFrmSalvarGrafico.EdtNomeArquivoKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (key = vk_down) and (shift = [ssAlt]) then
      btnNomeArq.click;
end;


procedure TFrmSalvarGrafico.btnNomeArqClick(Sender: TObject);
begin
  if SaveDialog1.Execute then
     EdtNomeArquivo.Text := SaveDialog1.FileName;
end;

end.
